/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.compat;

import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import xyz.przemyk.simpleplanes.compat.DirtChestSlot;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class IronChestsCompat {
    public static final String MODID = "ironchest";
    public static final String IRON_CHEST_NAME = "ironchest:iron_chest";
    public static final String GOLD_CHEST_NAME = "ironchest:gold_chest";
    public static final String DIAMOND_CHEST_NAME = "ironchest:diamond_chest";
    public static final String COPPER_CHEST_NAME = "ironchest:copper_chest";
    public static final String SILVER_CHEST_NAME = "ironchest:silver_chest";
    public static final String CRYSTAL_CHEST_NAME = "ironchest:crystal_chest";
    public static final String OBSIDIAN_CHEST_NAME = "ironchest:obsidian_chest";
    public static final String DIRT_CHEST_NAME = "ironchest:dirt_chest";
    @ObjectHolder(value="ironchest:iron_chest")
    public static final Item IRON_CHEST = null;
    @ObjectHolder(value="ironchest:gold_chest")
    public static final Item GOLD_CHEST = null;
    @ObjectHolder(value="ironchest:diamond_chest")
    public static final Item DIAMOND_CHEST = null;
    @ObjectHolder(value="ironchest:copper_chest")
    public static final Item COPPER_CHEST = null;
    @ObjectHolder(value="ironchest:silver_chest")
    public static final Item SILVER_CHEST = null;
    @ObjectHolder(value="ironchest:crystal_chest")
    public static final Item CRYSTAL_CHEST = null;
    @ObjectHolder(value="ironchest:obsidian_chest")
    public static final Item OBSIDIAN_CHEST = null;
    @ObjectHolder(value="ironchest:dirt_chest")
    public static final Item DIRT_CHEST = null;
    public static final ResourceLocation IRON_CHEST_GUI = new ResourceLocation("ironchest", "textures/gui/iron_container.png");
    public static final ResourceLocation GOLD_CHEST_GUI = new ResourceLocation("ironchest", "textures/gui/gold_container.png");
    public static final ResourceLocation DIAMOND_CHEST_GUI = new ResourceLocation("ironchest", "textures/gui/diamond_container.png");
    public static final ResourceLocation COPPER_CHEST_GUI = new ResourceLocation("ironchest", "textures/gui/copper_container.png");
    public static final ResourceLocation SILVER_CHEST_GUI = new ResourceLocation("ironchest", "textures/gui/silver_container.png");
    public static final ResourceLocation DIRT_CHEST_GUI = new ResourceLocation("ironchest", "textures/gui/dirt_container.png");
    public static final ResourceLocation VANILLA_CHEST_GUI = new ResourceLocation("simpleplanes", "textures/gui/vanilla_chest.png");

    private static void registerChest(Item chestItem) {
        if (chestItem != null) {
            SimplePlanesUpgrades.registerLargeUpgradeItem(chestItem, (UpgradeType)SimplePlanesUpgrades.CHEST.get());
        }
    }

    public static void registerUpgradeItems() {
        IronChestsCompat.registerChest(IRON_CHEST);
        IronChestsCompat.registerChest(GOLD_CHEST);
        IronChestsCompat.registerChest(DIAMOND_CHEST);
        IronChestsCompat.registerChest(COPPER_CHEST);
        IronChestsCompat.registerChest(SILVER_CHEST);
        IronChestsCompat.registerChest(CRYSTAL_CHEST);
        IronChestsCompat.registerChest(OBSIDIAN_CHEST);
        IronChestsCompat.registerChest(DIRT_CHEST);
    }

    public static int getSize(String chestType) {
        switch (chestType) {
            case "ironchest:iron_chest": {
                return 54;
            }
            case "ironchest:gold_chest": {
                return 81;
            }
            case "ironchest:diamond_chest": 
            case "ironchest:obsidian_chest": 
            case "ironchest:crystal_chest": {
                return 108;
            }
            case "ironchest:copper_chest": {
                return 45;
            }
            case "ironchest:silver_chest": {
                return 72;
            }
            case "ironchest:dirt_chest": {
                return 1;
            }
        }
        return 27;
    }

    public static int getRowCount(String chestType) {
        return IronChestsCompat.getSize(chestType) / IronChestsCompat.getRowLength(chestType);
    }

    public static int getRowLength(String chestType) {
        switch (chestType) {
            case "ironchest:diamond_chest": 
            case "ironchest:crystal_chest": 
            case "ironchest:obsidian_chest": {
                return 12;
            }
            case "ironchest:dirt_chest": {
                return 1;
            }
        }
        return 9;
    }

    public static void addSlots(String chestType, IItemHandler itemHandler, int rowCount, PlayerInventory playerInventory, Consumer<Slot> addSlotFunction) {
        if (chestType.equals(DIRT_CHEST_NAME)) {
            addSlotFunction.accept((Slot)new DirtChestSlot(itemHandler, 0, 84, 44));
        } else {
            int rowLength = IronChestsCompat.getRowLength(chestType);
            for (int row = 0; row < rowCount; ++row) {
                for (int column = 0; column < rowLength; ++column) {
                    addSlotFunction.accept((Slot)new SlotItemHandler(itemHandler, column + row * rowLength, 12 + column * 18, 18 + row * 18));
                }
            }
        }
        int xSize = IronChestsCompat.getXSize(chestType);
        int ySize = IronChestsCompat.getYSize(chestType);
        int leftCol = (xSize - 162) / 2 + 1;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                addSlotFunction.accept(new Slot((IInventory)playerInventory, column + row * 9 + 9, leftCol + column * 18, ySize - (4 - row) * 18 - 10));
            }
        }
        for (int column = 0; column < 9; ++column) {
            addSlotFunction.accept(new Slot((IInventory)playerInventory, column, leftCol + column * 18, ySize - 24));
        }
    }

    public static int getXSize(String chestType) {
        switch (chestType) {
            case "ironchest:diamond_chest": 
            case "ironchest:crystal_chest": 
            case "ironchest:obsidian_chest": {
                return 238;
            }
        }
        return 184;
    }

    public static int getYSize(String chestType) {
        switch (chestType) {
            case "ironchest:iron_chest": {
                return 222;
            }
            case "ironchest:gold_chest": 
            case "ironchest:diamond_chest": 
            case "ironchest:crystal_chest": 
            case "ironchest:obsidian_chest": {
                return 276;
            }
            case "ironchest:copper_chest": {
                return 204;
            }
            case "ironchest:dirt_chest": {
                return 184;
            }
        }
        return 168;
    }

    public static ResourceLocation getGuiTexture(String chestType) {
        switch (chestType) {
            case "ironchest:iron_chest": {
                return IRON_CHEST_GUI;
            }
            case "ironchest:gold_chest": {
                return GOLD_CHEST_GUI;
            }
            case "ironchest:diamond_chest": 
            case "ironchest:crystal_chest": 
            case "ironchest:obsidian_chest": {
                return DIAMOND_CHEST_GUI;
            }
            case "ironchest:copper_chest": {
                return COPPER_CHEST_GUI;
            }
            case "ironchest:silver_chest": {
                return SILVER_CHEST_GUI;
            }
            case "ironchest:dirt_chest": {
                return DIRT_CHEST_GUI;
            }
        }
        return VANILLA_CHEST_GUI;
    }

    public static int getTextureYSize(String chestType) {
        switch (chestType) {
            case "ironchest:gold_chest": 
            case "ironchest:diamond_chest": 
            case "ironchest:silver_chest": 
            case "ironchest:crystal_chest": 
            case "ironchest:obsidian_chest": {
                return 276;
            }
        }
        return 256;
    }
}

